--
-- Ricerca nel database per sapere di quale colore sono i modelli di moto
--

--
-- Ricerca con restituzione di tutte le colonne
--
SELECT *
  FROM moto LEFT JOIN colore ON moto.colore = colore.id_colore
  WHERE moto.modello = "Tuono 660";

--
-- Ricerca con restituzione delle sole colonne d'interesse
--
SELECT moto.marca,moto.modello,colore.colore,moto.note
  FROM moto LEFT JOIN colore ON moto.colore = colore.id_colore
  WHERE moto.modello = "Tuono 660";

--
-- Ricerca con criterio wildcard.
-- Tutti i modelli 660
--
SELECT moto.marca,moto.modello,colore.colore,moto.note
  FROM moto LEFT JOIN colore ON moto.colore = colore.id_colore
  WHERE moto.modello LIKE "%660";

--
-- Ricerca con criterio wildcard.
-- Tutte le versioni dei modelli Tuono
--
SELECT moto.marca,moto.modello,colore.colore,moto.note
  FROM moto LEFT JOIN colore ON moto.colore = colore.id_colore
  WHERE moto.modello LIKE "Tuono%";

--
-- Ricerca con criterio wildcard.
-- Tutte le versioni doppi zero di ogni modelli
--
SELECT moto.marca,moto.modello,colore.colore,moto.note
  FROM moto LEFT JOIN colore ON moto.colore = colore.id_colore
  WHERE moto.modello LIKE "%00%";

--
-- Ricerca con criterio wildcard doppio.
-- Tutte le versioni dei modelli S come seconda lettera
--
SELECT moto.marca,moto.modello,colore.colore,moto.note
  FROM moto LEFT JOIN colore ON moto.colore = colore.id_colore
  WHERE moto.modello LIKE "_S %";



